/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.apps.manager.IVWFolderOpenListener;
import filenet.vw.apps.manager.VWFolder;
import filenet.vw.apps.manager.VWFolderOpenEvent;
import filenet.vw.apps.manager.VWNodeInformation;
import filenet.vw.apps.manager.images.VWImageLoader;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.table.IVWTableOperation;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class VWFolderTableModel
extends AbstractTableModel
implements IVWTableOperation {
    private String[] m_headers = new String[]{VWResource.s_nameColumnHeader};
    private Class[] m_columnClasses = new Class[]{VWFolder.class};
    private Vector m_rowCache;
    private VWNodeInformation[] m_folderNodes = null;
    private EventListenerList m_folderOpenListenerList = null;
    private Icon m_folderIcon = null;
    private Icon m_userQueueIcon = null;
    private Icon m_workQueueIcon = null;
    private Icon m_launchedWorkflowsIcon = null;

    public VWFolderTableModel(VWNodeInformation[] folderNodes) {
        this.m_folderNodes = folderNodes;
        try {
            this.m_folderOpenListenerList = new EventListenerList();
            this.loadIcons();
            this.retrieveRowData();
            this.fireTableChanged(new TableModelEvent(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getRowCount() {
        return this.m_rowCache.size();
    }

    public int getColumnCount() {
        return this.m_headers.length;
    }

    public Class getColumnClass(int index) {
        return this.m_columnClasses[index];
    }

    public String getColumnName(int index) {
        return this.m_headers[index];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return null;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return null;
        }
        VWFolder rowData = (VWFolder)this.m_rowCache.elementAt(rowIndex);
        if (rowData != null) {
            return rowData;
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() - 1) {
            return;
        }
        if (columnIndex > this.getColumnCount() - 1) {
            return;
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void openItem(int rowIndex) {
        this.fireFolderOpened(new VWFolderOpenEvent(this, rowIndex));
    }

    public void refresh() {
        this.m_rowCache.removeAllElements();
        this.retrieveRowData();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addFolderOpenListener(IVWFolderOpenListener fol) {
        this.m_folderOpenListenerList.add(IVWFolderOpenListener.class, fol);
    }

    public void removeFolderOpenListener(IVWFolderOpenListener fol) {
        this.m_folderOpenListenerList.remove(IVWFolderOpenListener.class, fol);
    }

    private void retrieveRowData() {
        Icon tempIcon = null;
        try {
            this.m_rowCache = new Vector();
            if (this.m_folderNodes == null) {
                return;
            }
            for (int i = 0; i < this.m_folderNodes.length; ++i) {
                switch (this.m_folderNodes[i].getType()) {
                    case 1: {
                        tempIcon = this.m_folderIcon;
                        break;
                    }
                    case 4: {
                        tempIcon = this.m_launchedWorkflowsIcon;
                        break;
                    }
                    case 2: {
                        tempIcon = this.m_userQueueIcon;
                        break;
                    }
                    case 3: {
                        tempIcon = this.m_workQueueIcon;
                    }
                }
                this.m_rowCache.addElement(new VWFolder(this.m_folderNodes[i].getName(), tempIcon));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void fireFolderOpened(VWFolderOpenEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_folderOpenListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWFolderOpenListener.class) continue;
            ((IVWFolderOpenListener)listeners[i + 1]).folderOpened(event);
        }
    }

    private void loadIcons() {
        try {
            this.m_folderIcon = VWImageLoader.createImageIcon("closedfolder.gif");
            this.m_userQueueIcon = VWImageLoader.createImageIcon("q_user_16.gif");
            this.m_workQueueIcon = VWImageLoader.createImageIcon("q_work_16.gif");
            this.m_launchedWorkflowsIcon = VWImageLoader.createImageIcon("milestonetracking_16.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

